/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.dynamicvalue.common.SavedGainedLifeValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class WellOfLostDreamsEffect
extends OneShotEffect {
    WellOfLostDreamsEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may pay {X}, where X is less than or equal to the amount of life you gained. If you do, draw X cards";
    }

    private WellOfLostDreamsEffect(WellOfLostDreamsEffect effect) {
        super((OneShotEffect)effect);
    }

    public WellOfLostDreamsEffect copy() {
        return new WellOfLostDreamsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            int xValue;
            int amount = SavedGainedLifeValue.MANY.calculate(game, source, (Effect)this);
            if (amount > 0 && (xValue = controller.announceX(0, amount, "Announce the value for {X} (pay for draw cards)", game, source, true)) > 0) {
                if (new GenericManaCost(xValue).pay(source, game, source, controller.getId(), false)) {
                    game.informPlayers(controller.getLogName() + " payed {" + xValue + '}');
                    controller.drawCards(xValue, source, game);
                } else {
                    return false;
                }
            }
            return true;
        }
        return false;
    }
}

