/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Controllable;
import mage.game.Game;
import mage.game.permanent.Permanent;

class WerewolfRansackerEffect
extends OneShotEffect {
    WerewolfRansackerEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "destroy target artifact. If that artifact is put into a graveyard this way, {this} deals 3 damage to that artifact's controller";
    }

    private WerewolfRansackerEffect(WerewolfRansackerEffect effect) {
        super((OneShotEffect)effect);
    }

    public WerewolfRansackerEffect copy() {
        return new WerewolfRansackerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            return false;
        }
        permanent.destroy(source, game);
        if (game.getState().getZone(permanent.getId()) != Zone.GRAVEYARD) {
            return true;
        }
        Optional.ofNullable(permanent).map(Controllable::getControllerId).map(arg_0 -> ((Game)game).getPlayer(arg_0)).ifPresent(player -> player.damage(3, source, game));
        return true;
    }
}

