/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.Collection;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.common.PayEnergyCost;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.ExileZone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class WheelOfPotentialEffect
extends OneShotEffect {
    WheelOfPotentialEffect() {
        super(Outcome.DrawCard);
        this.staticText = ", then you may pay X {E}.<br>Each player may exile their hand and draw X cards. If X is 7 or more, you may play cards you own exiled this way until the end of your next turn.";
    }

    private WheelOfPotentialEffect(WheelOfPotentialEffect effect) {
        super((OneShotEffect)effect);
    }

    public WheelOfPotentialEffect copy() {
        return new WheelOfPotentialEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        int numberToPay = controller.getAmount(0, controller.getCountersCount(CounterType.ENERGY), "How many {E} do you want to pay?", source, game);
        PayEnergyCost cost = new PayEnergyCost(numberToPay);
        int numberPaid = 0;
        if (cost.pay(source, game, source, controller.getId(), true)) {
            numberPaid = numberToPay;
        }
        CardsImpl cardsExiled = new CardsImpl();
        for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
            Outcome outcome;
            Player player = game.getPlayer(playerId);
            if (playerId == null) continue;
            Outcome outcome2 = outcome = player.getHand().size() > numberPaid ? Outcome.Discard : Outcome.DrawCard;
            if (!player.chooseUse(outcome, "Exile your hand and draw " + numberPaid + "?", source, game)) {
                game.informPlayers(player.getLogName() + " chose to not exile their hand");
                continue;
            }
            cardsExiled.addAll((Collection)player.getHand());
            player.moveCardsToExile(player.getHand().getCards(game), source, game, true, null, "");
            player.drawCards(numberPaid, source, game);
        }
        if (numberPaid >= 7) {
            game.processAction();
            cardsExiled.removeIf(cardId -> {
                Card card = game.getCard(cardId);
                return card == null || !card.getOwnerId().equals(controller.getId());
            });
            cardsExiled.retainZone(Zone.EXILED, game);
            String exileName = CardUtil.getSourceIdName((Game)game, (Ability)source);
            UUID exileId = CardUtil.getExileZoneId((Game)game, (Ability)source);
            ExileZone exileZone = game.getExile().createZone(exileId, exileName);
            for (Card card : cardsExiled.getCards(game)) {
                game.getExile().moveToAnotherZone(card, game, exileZone);
                CardUtil.makeCardPlayable((Game)game, (Ability)source, (Card)card, (boolean)false, (Duration)Duration.UntilEndOfYourNextTurn, (boolean)false);
            }
        }
        return true;
    }
}

