/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.LinkedHashSet;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.choices.Choice;
import mage.choices.ChoiceImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class WhenFluffyBunniesAttackEffect
extends OneShotEffect {
    WhenFluffyBunniesAttackEffect() {
        super(Outcome.Detriment);
        this.staticText = "Target creature gets -X/-X until end of turn, where X is the number of times the letter of your choice appears in that creature's name";
    }

    private WhenFluffyBunniesAttackEffect(WhenFluffyBunniesAttackEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        ChoiceImpl choice = new ChoiceImpl(true);
        choice.setMessage("Choose letter");
        LinkedHashSet<String> choices = new LinkedHashSet<String>();
        Character letter = Character.valueOf('A');
        while (letter.charValue() <= 'Z') {
            choices.add(letter.toString());
            Character c = letter;
            Character c2 = letter = Character.valueOf((char)(letter.charValue() + '\u0001'));
        }
        choice.setChoices(choices);
        if (controller != null && permanent != null && controller.choose(this.outcome, (Choice)choice, game)) {
            MageObject mageObject;
            if (!game.isSimulation() && (mageObject = game.getObject(source)) != null) {
                game.informPlayers(mageObject.getLogName() + ": " + controller.getLogName() + " has chosen " + choice.getChoice());
            }
            Character chosenLetter = Character.valueOf(choice.getChoice().charAt(0));
            int unboostValue = 0;
            String permName = permanent.getName();
            for (int i = 0; i < permName.length(); ++i) {
                Character letter2 = Character.valueOf(permName.charAt(i));
                if (!Character.isLetter(letter2.charValue()) || Character.toUpperCase(letter2.charValue()) != chosenLetter.charValue()) continue;
                --unboostValue;
            }
            BoostTargetEffect effect = new BoostTargetEffect(unboostValue, unboostValue, Duration.EndOfTurn);
            effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
            game.addEffect((ContinuousEffect)effect, source);
            return true;
        }
        return false;
    }

    public WhenFluffyBunniesAttackEffect copy() {
        return new WhenFluffyBunniesAttackEffect(this);
    }
}

