/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.LinkedEffectIdStaticAbility;
import mage.abilities.costs.mana.ManaCosts;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.dynamicvalue.common.PermanentsOnBattlefieldCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.PayCostToAttackBlockEffectImpl;
import mage.abilities.effects.common.combat.CantAttackBlockUnlessPaysSourceEffect;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class WhipgrassEntanglerCantAttackUnlessYouPayEffect
extends CantAttackBlockUnlessPaysSourceEffect
implements LinkedEffectIdStaticAbility.ChildEffect {
    private static final FilterPermanent filter = new FilterPermanent("Cleric on the battlefield");
    private UUID parentLinkHandshake = null;

    WhipgrassEntanglerCantAttackUnlessYouPayEffect() {
        super((ManaCosts)new ManaCostsImpl("{0}"), PayCostToAttackBlockEffectImpl.RestrictType.ATTACK_AND_BLOCK);
        this.staticText = "This creature can't attack or block unless its controller pays {1} for each Cleric on the battlefield";
    }

    private WhipgrassEntanglerCantAttackUnlessYouPayEffect(WhipgrassEntanglerCantAttackUnlessYouPayEffect effect) {
        super((CantAttackBlockUnlessPaysSourceEffect)effect);
        this.parentLinkHandshake = effect.parentLinkHandshake;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return source.getSourceId().equals(event.getSourceId()) && source instanceof LinkedEffectIdStaticAbility && ((LinkedEffectIdStaticAbility)source).checkLinked(this.parentLinkHandshake);
    }

    public ManaCosts getManaCostToPay(GameEvent event, Ability source, Game game) {
        int payment;
        Permanent sourceObject = game.getPermanent(source.getSourceId());
        if (sourceObject != null && (payment = new PermanentsOnBattlefieldCount(filter).calculate(game, source, (Effect)this)) > 0) {
            return new ManaCostsImpl("{" + payment + '}');
        }
        return null;
    }

    public WhipgrassEntanglerCantAttackUnlessYouPayEffect copy() {
        return new WhipgrassEntanglerCantAttackUnlessYouPayEffect(this);
    }

    public void newId() {
    }

    public void manualNewId() {
        super.newId();
    }

    public void setParentLinkHandshake(UUID parentLinkHandshake) {
        this.parentLinkHandshake = parentLinkHandshake;
    }

    static {
        filter.add((Predicate)SubType.CLERIC.getPredicate());
    }
}

