/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.abilities.keyword.FlyingAbility;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.AbilityPredicate;
import mage.game.Game;

class WhiptongueHydraEffect
extends OneShotEffect {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent();

    public WhiptongueHydraEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "destroy all creatures with flying. Put a +1/+1 counter on {this} for each creature destroyed this way";
    }

    private WhiptongueHydraEffect(WhiptongueHydraEffect effect) {
        super((OneShotEffect)effect);
    }

    public WhiptongueHydraEffect copy() {
        return new WhiptongueHydraEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int destroyedPermanents = game.getBattlefield().getActivePermanents((FilterPermanent)filter, source.getControllerId(), source, game).stream().filter(permanent -> permanent.destroy(source, game, false)).mapToInt(x -> 1).sum();
        if (destroyedPermanents > 0) {
            game.processAction();
            new AddCountersSourceEffect(CounterType.P1P1.createInstance(destroyedPermanents), true).apply(game, source);
        }
        return true;
    }

    static {
        filter.add((Predicate)new AbilityPredicate(FlyingAbility.class));
    }
}

