/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ClashEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class WhirlpoolWhelmEffect
extends OneShotEffect {
    WhirlpoolWhelmEffect() {
        super(Outcome.ReturnToHand);
        this.staticText = "Clash with an opponent, then return target creature to its owner's hand. If you win, you may put that creature on top of its owner's library instead";
    }

    private WhirlpoolWhelmEffect(WhirlpoolWhelmEffect effect) {
        super((OneShotEffect)effect);
    }

    public WhirlpoolWhelmEffect copy() {
        return new WhirlpoolWhelmEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent creature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (controller != null) {
            boolean topOfLibrary = false;
            if (new ClashEffect().apply(game, source)) {
                topOfLibrary = controller.chooseUse(this.outcome, "Put " + creature.getLogName() + " to top of its owner's library instead?", source, game);
            }
            if (topOfLibrary) {
                controller.moveCardToLibraryWithInfo((Card)creature, source, game, Zone.BATTLEFIELD, true, true);
            } else {
                controller.moveCards((Card)creature, Zone.HAND, source, game);
            }
            return true;
        }
        return false;
    }
}

