/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.Card;
import mage.cards.w.WhispersteelDaggerWatcher;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;

class WhispersteelDaggerCastFromExileEffect
extends AsThoughEffectImpl {
    WhispersteelDaggerCastFromExileEffect() {
        super(AsThoughEffectType.CAST_FROM_NOT_OWN_HAND_ZONE, Duration.EndOfTurn, Outcome.Benefit);
        this.staticText = "you may cast a creature spell from that player's graveyard this turn";
    }

    private WhispersteelDaggerCastFromExileEffect(WhispersteelDaggerCastFromExileEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public WhispersteelDaggerCastFromExileEffect copy() {
        return new WhispersteelDaggerCastFromExileEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        WhispersteelDaggerWatcher watcher = (WhispersteelDaggerWatcher)game.getState().getWatcher(WhispersteelDaggerWatcher.class);
        if (watcher != null) {
            watcher.addPlayable(source, this.getTargetPointer().getFirst(game, source), game);
        }
    }

    public boolean applies(UUID sourceId, Ability source, UUID affectedControllerId, Game game) {
        return WhispersteelDaggerCastFromExileEffect.applyCheck(sourceId, source, affectedControllerId, game, this.getTargetPointer().getFirst(game, source));
    }

    static boolean applyCheck(UUID sourceId, Ability source, UUID affectedControllerId, Game game, UUID targetId) {
        WhispersteelDaggerWatcher watcher = (WhispersteelDaggerWatcher)game.getState().getWatcher(WhispersteelDaggerWatcher.class);
        if (watcher == null || !watcher.checkPermission(affectedControllerId, targetId, source, game) || game.getState().getZone(sourceId) != Zone.GRAVEYARD && game.getState().getZone(sourceId) != Zone.STACK) {
            return false;
        }
        Card card = game.getCard(sourceId);
        return card != null && card.getOwnerId().equals(targetId) && card.isCreature(game) && !card.isLand(game);
    }
}

