/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.TappedPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.watchers.common.CompletedDungeonWatcher;

class WhitePlumeAdventurerEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledCreaturePermanent("tapped creature you control");

    WhitePlumeAdventurerEffect() {
        super(Outcome.Benefit);
        this.staticText = "untap a creature you control. If you've completed a dungeon, untap all creatures you control instead";
    }

    private WhitePlumeAdventurerEffect(WhitePlumeAdventurerEffect effect) {
        super((OneShotEffect)effect);
    }

    public WhitePlumeAdventurerEffect copy() {
        return new WhitePlumeAdventurerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        if (!game.getBattlefield().contains(filter, source, game, 1)) {
            return false;
        }
        if (CompletedDungeonWatcher.checkPlayer((UUID)source.getControllerId(), (Game)game)) {
            for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, source.getControllerId(), source, game)) {
                permanent.untap(game);
            }
            return true;
        }
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetPermanent target = new TargetPermanent(filter);
        target.withNotTarget(true);
        player.choose(this.outcome, (Target)target, source, game);
        Permanent permanent = game.getPermanent(target.getFirstTarget());
        return permanent != null && permanent.untap(game);
    }

    static {
        filter.add((Predicate)TappedPredicate.TAPPED);
    }
}

