/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.PermanentReferenceInCollectionPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class WickedSlumberEffect
extends OneShotEffect {
    WickedSlumberEffect() {
        super(Outcome.Benefit);
        this.staticText = "put a stun counter on either of them. Then put a stun counter on either of them";
    }

    private WickedSlumberEffect(WickedSlumberEffect effect) {
        super((OneShotEffect)effect);
    }

    public WickedSlumberEffect copy() {
        return new WickedSlumberEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        List permanents = this.getTargetPointer().getTargets(game, source).stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        if (player == null || permanents.isEmpty()) {
            return false;
        }
        if (permanents.size() == 1) {
            ((Permanent)permanents.get(0)).addCounters(CounterType.STUN.createInstance(), source, game);
            ((Permanent)permanents.get(0)).addCounters(CounterType.STUN.createInstance(), source, game);
            return true;
        }
        FilterCreaturePermanent filter = new FilterCreaturePermanent();
        filter.add((Predicate)new PermanentReferenceInCollectionPredicate(permanents, game));
        for (int i = 0; i < 2; ++i) {
            TargetPermanent target = new TargetPermanent((FilterPermanent)filter);
            target.withNotTarget(true);
            target.withChooseHint("to add the " + (i == 0 ? "first" : "second") + " stun counter to");
            player.choose(this.outcome, (Target)target, source, game);
            Permanent permanent = game.getPermanent(target.getFirstTarget());
            if (permanent == null) continue;
            permanent.addCounters(CounterType.STUN.createInstance(), source, game);
        }
        return true;
    }
}

