/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.cards.w.WicksPatrolValue;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetOpponentsCreaturePermanent;

class WicksPatrolEffect
extends OneShotEffect {
    WicksPatrolEffect() {
        super(Outcome.Benefit);
        this.staticText = "mill three cards. When you do, target creature an opponent controls gets -X/-X until end of turn, where X is the greatest mana value among cards in your graveyard";
    }

    private WicksPatrolEffect(WicksPatrolEffect effect) {
        super((OneShotEffect)effect);
    }

    public WicksPatrolEffect copy() {
        return new WicksPatrolEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null || player.millCards(3, source, game).size() < 3) {
            return false;
        }
        ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new BoostTargetEffect((DynamicValue)WicksPatrolValue.instance, (DynamicValue)WicksPatrolValue.instance), false).setTriggerPhrase("When you do, ");
        ability.addTarget((Target)new TargetOpponentsCreaturePermanent());
        game.fireReflexiveTriggeredAbility(ability, source);
        return true;
    }
}

