/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.w.WildPairPowerToughnessPredicate;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class WildPairEffect
extends OneShotEffect {
    WildPairEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "search your library for a creature card with the same total power and toughness, put it onto the battlefield, then shuffle";
    }

    private WildPairEffect(WildPairEffect effect) {
        super((OneShotEffect)effect);
    }

    public WildPairEffect copy() {
        return new WildPairEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = (Permanent)this.getValue("permanentEnteringBattlefield");
        if (controller == null || permanent == null) {
            return false;
        }
        int totalPT = permanent.getPower().getValue() + permanent.getToughness().getValue();
        FilterCreatureCard filter = new FilterCreatureCard("creature card with total power and toughness " + totalPT);
        filter.add((Predicate)new WildPairPowerToughnessPredicate(totalPT));
        TargetCardInLibrary target = new TargetCardInLibrary(1, (FilterCard)filter);
        controller.searchLibrary(target, source, game);
        controller.moveCards((Cards)new CardsImpl(controller.getLibrary().getCard(target.getFirstTarget(), game)), Zone.BATTLEFIELD, source, game);
        controller.shuffleLibrary(source, game);
        return true;
    }
}

