/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.cost.SpellsCostReductionAllEffect;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;

class WillKenrithCostReductionEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard();

    WillKenrithCostReductionEffect() {
        super(Outcome.Benefit);
        this.staticText = "Until your next turn, instant, sorcery, and planeswalker spells that player casts cost {2} less to cast";
    }

    private WillKenrithCostReductionEffect(WillKenrithCostReductionEffect effect) {
        super((OneShotEffect)effect);
    }

    public WillKenrithCostReductionEffect copy() {
        return new WillKenrithCostReductionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        SpellsCostReductionAllEffect effect = new SpellsCostReductionAllEffect(filter, 2);
        effect.setDuration(Duration.UntilYourNextTurn);
        effect.setControllerId(source.getFirstTarget());
        game.addEffect((ContinuousEffect)effect, source);
        return true;
    }

    static {
        filter.add(Predicates.or((Predicate[])new Predicate[]{CardType.INSTANT.getPredicate(), CardType.SORCERY.getPredicate(), CardType.PLANESWALKER.getPredicate()}));
    }
}

