/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.ArrayList;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class WillOfTheJeskaiEffect
extends OneShotEffect {
    WillOfTheJeskaiEffect() {
        super(Outcome.Benefit);
        this.staticText = "each player may discard their hand and draw five cards";
    }

    private WillOfTheJeskaiEffect(WillOfTheJeskaiEffect effect) {
        super((OneShotEffect)effect);
    }

    public WillOfTheJeskaiEffect copy() {
        return new WillOfTheJeskaiEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        ArrayList<Player> wheelers = new ArrayList<Player>();
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null || !player.chooseUse(Outcome.DrawCard, "Discard your hand and draw five?", source, game)) continue;
            game.informPlayers(player.getName() + " chooses to discard their hand and draw five");
            wheelers.add(player);
        }
        for (Player player : wheelers) {
            player.discard(player.getHand(), false, source, game);
            player.drawCards(5, source, game);
        }
        return true;
    }
}

