/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.dynamicvalue.common.ControllerGainedLifeCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.util.CardUtil;

class WillScionOfPeaceEffect
extends CostModificationEffectImpl {
    WillScionOfPeaceEffect() {
        super(Duration.EndOfTurn, Outcome.Benefit, CostModificationType.REDUCE_COST);
        this.staticText = "Spells you cast this turn that are white and/or blue cost {X} less to cast, where X is the amount of life you gained this turn.";
    }

    private WillScionOfPeaceEffect(WillScionOfPeaceEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        CardUtil.reduceCost((Ability)abilityToModify, (int)Math.max(0, ControllerGainedLifeCount.instance.calculate(game, source, (Effect)this)));
        return true;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        if (!(abilityToModify instanceof SpellAbility)) {
            return false;
        }
        SpellAbility spell = (SpellAbility)abilityToModify;
        ObjectColor color = spell.getCharacteristics(game).getColor(game);
        return spell.isControlledBy(source.getControllerId()) && game.getCard(spell.getSourceId()) != null && (color.isBlue() || color.isWhite());
    }

    public WillScionOfPeaceEffect copy() {
        return new WillScionOfPeaceEffect(this);
    }
}

