/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.filter.common.FilterCreatureCard;
import mage.game.Game;
import mage.players.Player;

class WindingWayEffect
extends OneShotEffect {
    WindingWayEffect() {
        super(Outcome.Benefit);
        this.staticText = "Choose creature or land. Reveal the top four cards of your library. Put all cards of the chosen type revealed this way into your hand and the rest into your graveyard.";
    }

    private WindingWayEffect(WindingWayEffect effect) {
        super((OneShotEffect)effect);
    }

    public WindingWayEffect copy() {
        return new WindingWayEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        boolean isCreature = player.chooseUse(this.outcome, "Creature or Land?", "", "Creature", "Land", source, game);
        FilterCreatureCard filter = isCreature ? StaticFilters.FILTER_CARD_CREATURE_A : StaticFilters.FILTER_CARD_LAND_A;
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, 4));
        player.revealCards(source, (Cards)cards, game);
        CardsImpl cardsToKeep = new CardsImpl(cards.getCards((FilterCard)filter, game));
        cards.removeAll((Collection)cardsToKeep);
        player.moveCards((Cards)cardsToKeep, Zone.HAND, source, game);
        player.moveCards((Cards)cards, Zone.GRAVEYARD, source, game);
        return true;
    }
}

