/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.HashMap;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class WindsOfChangeEffect
extends OneShotEffect {
    WindsOfChangeEffect() {
        super(Outcome.Benefit);
        this.staticText = "Each player shuffles the cards from their hand into their library, then draws that many cards";
    }

    private WindsOfChangeEffect(WindsOfChangeEffect effect) {
        super((OneShotEffect)effect);
    }

    public WindsOfChangeEffect copy() {
        return new WindsOfChangeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Player player;
            HashMap<UUID, Integer> permanentsCount = new HashMap<UUID, Integer>();
            for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
                player = game.getPlayer(playerId);
                if (player == null) continue;
                permanentsCount.put(playerId, player.getHand().size());
                player.moveCards(player.getHand(), Zone.LIBRARY, source, game);
                player.shuffleLibrary(source, game);
            }
            for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
                player = game.getPlayer(playerId);
                if (player == null || !permanentsCount.containsKey(playerId)) continue;
                player.drawCards(((Integer)permanentsCount.get(playerId)).intValue(), source, game);
            }
            return true;
        }
        return false;
    }
}

