/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.CardTypesInGraveyardCount;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.effects.Effect;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.players.Player;

class WinterMisanthropicGuideEffect
extends ContinuousEffectImpl {
    WinterMisanthropicGuideEffect() {
        super(Duration.WhileOnBattlefield, Layer.PlayerEffects, SubLayer.NA, Outcome.Neutral);
        this.staticText = "as long as there are four or more card types among cards in your graveyard, each opponent's maximum hand size is equal to seven minus the number of those card types";
    }

    private WinterMisanthropicGuideEffect(WinterMisanthropicGuideEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public WinterMisanthropicGuideEffect copy() {
        return new WinterMisanthropicGuideEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int count = CardTypesInGraveyardCount.YOU.calculate(game, source, (Effect)this);
        if (count < 4) {
            return false;
        }
        for (UUID opponentId : game.getOpponents(source.getControllerId())) {
            Player player = game.getPlayer(opponentId);
            if (player == null) continue;
            player.setMaxHandSize(Math.max(7 - count, 0));
        }
        return true;
    }
}

