/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DamageEverythingEffect;
import mage.abilities.effects.common.DrawCardAllEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class WinterSkyEffect
extends OneShotEffect {
    WinterSkyEffect() {
        super(Outcome.Damage);
        this.staticText = "Flip a coin. If you win the flip, {this} deals 1 damage to each creature and each player. If you lose the flip, each player draws a card";
    }

    private WinterSkyEffect(WinterSkyEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            if (controller.flipCoin(source, game, true)) {
                new DamageEverythingEffect(1).apply(game, source);
                return true;
            }
            new DrawCardAllEffect(1).apply(game, source);
            return true;
        }
        return false;
    }

    public WinterSkyEffect copy() {
        return new WinterSkyEffect(this);
    }
}

