/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.EncoreAbility;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;

class WireSurgeonsEffect
extends ContinuousEffectImpl {
    private static final FilterCreatureCard filter = new FilterCreatureCard("artifact creature card");

    public WireSurgeonsEffect() {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "Each artifact creature card in your graveyard has encore. Its encore cost is equal to its mana cost.";
    }

    private WireSurgeonsEffect(WireSurgeonsEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public WireSurgeonsEffect copy() {
        return new WireSurgeonsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        for (Card card : player.getGraveyard().getCards((FilterCard)filter, game)) {
            EncoreAbility ability = new EncoreAbility((Cost)card.getManaCost());
            ability.setSourceId(card.getId());
            ability.setControllerId(card.getOwnerId());
            game.getState().addOtherAbility(card, (Ability)ability);
        }
        return true;
    }

    static {
        filter.add((Predicate)CardType.ARTIFACT.getPredicate());
    }
}

