/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.CardsInHandCondition;
import mage.abilities.decorator.ConditionalOneShotEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.abilities.effects.common.HideawayPlayEffect;
import mage.constants.ComparisonType;
import mage.constants.PhaseStep;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;
import mage.watchers.common.CardsDrawnDuringDrawStepWatcher;

class WiretappingTriggeredAbility
extends TriggeredAbilityImpl {
    private static final Condition condition = new CardsInHandCondition(ComparisonType.MORE_THAN, 8);

    WiretappingTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DrawCardSourceControllerEffect(1));
        this.addEffect((Effect)new ConditionalOneShotEffect((OneShotEffect)new HideawayPlayEffect(), condition));
        this.addWatcher((Watcher)new CardsDrawnDuringDrawStepWatcher());
    }

    private WiretappingTriggeredAbility(WiretappingTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public WiretappingTriggeredAbility copy() {
        return new WiretappingTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DREW_CARD;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        return game.isActivePlayer(event.getPlayerId()) && game.getTurnStepType() == PhaseStep.DRAW && this.isControlledBy(event.getPlayerId()) && ((CardsDrawnDuringDrawStepWatcher)game.getState().getWatcher(CardsDrawnDuringDrawStepWatcher.class)).getAmountCardsDrawn(event.getPlayerId()) == 1;
    }

    public String getRule() {
        return "Whenever you draw your first card during each of your draw steps, draw a card. Then if you have nine or more cards in hand, you may play the exiled card without paying its mana cost.";
    }
}

