/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.HashSet;
import java.util.Set;
import mage.MageIdentifier;
import mage.MageObjectReference;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

class WishWatcher
extends Watcher {
    private final Set<MageObjectReference> usedFrom = new HashSet<MageObjectReference>();

    WishWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if ((GameEvent.EventType.SPELL_CAST.equals((Object)event.getType()) || GameEvent.EventType.LAND_PLAYED.equals((Object)event.getType())) && event.hasApprovingIdentifier(MageIdentifier.WishWatcher)) {
            this.usedFrom.add(event.getApprovingObject().getApprovingMageObjectReference());
        }
    }

    public void reset() {
        super.reset();
        this.usedFrom.clear();
    }

    boolean isAbilityUsed(MageObjectReference mor) {
        return this.usedFrom.contains(mor);
    }
}

