/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.DefenderAbility;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class WishfulMerfolkEffect
extends ContinuousEffectImpl {
    WishfulMerfolkEffect() {
        super(Duration.EndOfTurn, Outcome.AddAbility);
        this.staticText = "{this} loses defender and becomes a Human until end of turn";
    }

    private WishfulMerfolkEffect(WishfulMerfolkEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public WishfulMerfolkEffect copy() {
        return new WishfulMerfolkEffect(this);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent == null) {
            return false;
        }
        switch (layer) {
            case AbilityAddingRemovingEffects_6: {
                permanent.removeAbility((Ability)DefenderAbility.getInstance(), source.getSourceId(), game);
                break;
            }
            case TypeChangingEffects_4: {
                permanent.removeAllCreatureTypes(game);
                permanent.addSubType(game, new SubType[]{SubType.HUMAN});
            }
        }
        return true;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.AbilityAddingRemovingEffects_6 || layer == Layer.TypeChangingEffects_4;
    }
}

