/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.MayCastTargetCardEffect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.constants.CastManaAdjustment;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterCard;
import mage.filter.common.FilterInstantOrSorceryCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;

class WishingWellEffect
extends OneShotEffect {
    WishingWellEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Put a coin counter on {this}. When you do, you may cast target instant or sorcery card with mana value equal to the number of coin counters on {this} from your graveyard without paying its mana cost. If that spell would be put into your graveyard, exile it instead";
    }

    private WishingWellEffect(WishingWellEffect effect) {
        super((OneShotEffect)effect);
    }

    public WishingWellEffect copy() {
        return new WishingWellEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        if (!new AddCountersSourceEffect(CounterType.COIN.createInstance(), true).apply(game, source)) {
            return false;
        }
        Permanent permanent = source.getSourcePermanentOrLKI(game);
        if (permanent == null) {
            return false;
        }
        int count = permanent.getCounters(game).getCount(CounterType.COIN);
        FilterInstantOrSorceryCard filter = new FilterInstantOrSorceryCard("instant or sorcery card with mana value " + count);
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.EQUAL_TO, count));
        ReflexiveTriggeredAbility reflexive = new ReflexiveTriggeredAbility((Effect)new MayCastTargetCardEffect(CastManaAdjustment.WITHOUT_PAYING_MANA_COST, true), true, "When you do, you may cast target instant or sorcery card with mana value equal to the number of coin counters on {this} from your graveyard without paying its mana cost. If that spell would be put into your graveyard, exile it instead");
        reflexive.addTarget((Target)new TargetCardInYourGraveyard((FilterCard)filter));
        game.fireReflexiveTriggeredAbility(reflexive, source);
        return true;
    }
}

