/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.ArrayList;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class WitchbaneOrbEffect
extends OneShotEffect {
    WitchbaneOrbEffect() {
        super(Outcome.Protect);
        this.staticText = "destroy all Curses attached to you";
    }

    private WitchbaneOrbEffect(WitchbaneOrbEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            ArrayList<Permanent> toDestroy = new ArrayList<Permanent>();
            for (UUID attachmentId : controller.getAttachments()) {
                Permanent attachment = game.getPermanent(attachmentId);
                if (attachment == null || !attachment.hasSubtype(SubType.CURSE, game)) continue;
                toDestroy.add(attachment);
            }
            for (Permanent curse : toDestroy) {
                curse.destroy(source, game, false);
            }
            return true;
        }
        return false;
    }

    public WitchbaneOrbEffect copy() {
        return new WitchbaneOrbEffect(this);
    }
}

