/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ReturnToHandTargetEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.ManaUtil;

class WithdrawEffect
extends OneShotEffect {
    WithdrawEffect() {
        super(Outcome.ReturnToHand);
        this.staticText = "Return target creature to its owner's hand. Then return another target creature to its owner's hand unless its controller pays {1}";
    }

    private WithdrawEffect(WithdrawEffect effect) {
        super((OneShotEffect)effect);
    }

    public WithdrawEffect copy() {
        return new WithdrawEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player creatureController;
        ReturnToHandTargetEffect effect = new ReturnToHandTargetEffect();
        effect.setTargetPointer((TargetPointer)new FixedTarget(source.getFirstTarget(), game));
        effect.apply(game, source);
        Permanent secondCreature = game.getPermanent(((Target)source.getTargets().get(1)).getFirstTarget());
        if (secondCreature != null && (creatureController = game.getPlayer(secondCreature.getControllerId())) != null) {
            ManaCost cost = ManaUtil.createManaCost((int)1, (boolean)false);
            if (creatureController.chooseUse(Outcome.Benefit, "Pay {1}? (Otherwise " + secondCreature.getName() + " will be returned to its owner's hand)", source, game)) {
                cost.pay(source, game, source, creatureController.getId(), false);
            }
            if (!cost.isPaid()) {
                creatureController.moveCards((Card)secondCreature, Zone.HAND, source, game);
            }
        }
        return true;
    }
}

