/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;

class WitherbloomCommandEffect
extends OneShotEffect {
    WitherbloomCommandEffect() {
        super(Outcome.ReturnToHand);
        this.staticText = ", then you return a land card from your graveyard to your hand";
    }

    private WitherbloomCommandEffect(WitherbloomCommandEffect effect) {
        super((OneShotEffect)effect);
    }

    public WitherbloomCommandEffect copy() {
        return new WitherbloomCommandEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetCardInYourGraveyard target = new TargetCardInYourGraveyard(1, (FilterCard)StaticFilters.FILTER_CARD_LAND);
        target.withNotTarget(true);
        if (!target.canChoose(source.getControllerId(), source, game)) {
            return false;
        }
        player.choose(this.outcome, (Target)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        return card != null && player.moveCards(card, Zone.HAND, source, game);
    }
}

