/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.List;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.combat.CombatGroup;
import mage.players.Player;

class WithinRangeEffect
extends OneShotEffect {
    WithinRangeEffect() {
        super(Outcome.Benefit);
        this.staticText = "each opponent loses life equal to the number of creatures attacking them";
    }

    private WithinRangeEffect(WithinRangeEffect effect) {
        super((OneShotEffect)effect);
    }

    public WithinRangeEffect copy() {
        return new WithinRangeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (UUID playerId : game.getOpponents(source.getControllerId())) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            int count = game.getCombat().getGroups().stream().filter(combatGroup -> player.getId().equals(combatGroup.getDefenderId())).map(CombatGroup::getAttackers).mapToInt(List::size).sum();
            player.loseLife(count, game, source, false);
        }
        return true;
    }
}

