/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.Token;
import mage.game.permanent.token.ZombieWhiteToken;
import mage.game.stack.StackAbility;

class WizenedMentorTriggeredAbility
extends TriggeredAbilityImpl {
    WizenedMentorTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new CreateTokenEffect((Token)new ZombieWhiteToken()));
        this.setTriggerPhrase("Whenever an opponent activates an ability of a permanent that isn't a mana ability, you ");
        this.setTriggersLimitEachTurn(1);
    }

    private WizenedMentorTriggeredAbility(WizenedMentorTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public WizenedMentorTriggeredAbility copy() {
        return new WizenedMentorTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ACTIVATED_ABILITY;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent source;
        if (!event.getPlayerId().equals(this.getControllerId()) && (source = game.getPermanentOrLKIBattlefield(event.getSourceId())) != null) {
            StackAbility stackAbility = (StackAbility)game.getStack().getStackObject(event.getSourceId());
            return !stackAbility.getStackAbility().isManaActivatedAbility();
        }
        return false;
    }
}

