/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.HashSet;
import java.util.Set;
import mage.abilities.costs.common.ReturnToHandChosenControlledPermanentCost;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.SubTypeSet;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.common.TargetControlledPermanent;

class WonderscapeSageReturnCost
extends ReturnToHandChosenControlledPermanentCost {
    private final Set<SubType> nonBasicLandTypes = new HashSet<SubType>();

    WonderscapeSageReturnCost() {
        super(new TargetControlledPermanent(StaticFilters.FILTER_CONTROLLED_PERMANENT_LAND));
        this.setText("Return a land you control to its owner's hand");
    }

    private WonderscapeSageReturnCost(WonderscapeSageReturnCost cost) {
        super((ReturnToHandChosenControlledPermanentCost)cost);
        this.nonBasicLandTypes.addAll(cost.nonBasicLandTypes);
    }

    public WonderscapeSageReturnCost copy() {
        return new WonderscapeSageReturnCost(this);
    }

    Set<SubType> getNonBasicLandTypes() {
        return this.nonBasicLandTypes;
    }

    protected void addReturnTarget(Game game, Permanent permanent) {
        super.addReturnTarget(game, permanent);
        if (permanent.getCardType(game).contains(CardType.LAND)) {
            permanent.getSubtype(game).stream().filter(s -> s.getSubTypeSet().equals((Object)SubTypeSet.NonBasicLandType)).forEach(this.nonBasicLandTypes::add);
        }
    }
}

