/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.Collection;
import mage.ApprovingObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.util.RandomUtil;

class WondrousCrucibleEffect
extends OneShotEffect {
    WondrousCrucibleEffect() {
        super(Outcome.Benefit);
        this.staticText = "mill two cards, then exile a nonland card at random from your graveyard. Copy it. You may cast the copy without paying its mana cost";
    }

    private WondrousCrucibleEffect(WondrousCrucibleEffect effect) {
        super((OneShotEffect)effect);
    }

    public WondrousCrucibleEffect copy() {
        return new WondrousCrucibleEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        player.millCards(2, source, game);
        Card card = (Card)RandomUtil.randomFromCollection((Collection)player.getGraveyard().getCards((FilterCard)StaticFilters.FILTER_CARD_NON_LAND, game));
        if (card == null) {
            return true;
        }
        player.moveCards(card, Zone.EXILED, source, game);
        Card copiedCard = game.copyCard(card, source, player.getId());
        if (!player.chooseUse(this.outcome, "Cast copy of " + card.getName() + " without paying its mana cost?", source, game)) {
            return true;
        }
        game.getState().setValue("PlayFromNotOwnHandZone" + copiedCard.getId(), (Object)Boolean.TRUE);
        player.cast(player.chooseAbilityForCast(copiedCard, game, true), game, true, new ApprovingObject(source, game));
        game.getState().setValue("PlayFromNotOwnHandZone" + copiedCard.getId(), null);
        return true;
    }
}

