/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.Objects;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeGroupEvent;
import mage.game.permanent.PermanentImpl;

class WoodlandChampionTriggeredAbility
extends TriggeredAbilityImpl {
    WoodlandChampionTriggeredAbility() {
        super(Zone.BATTLEFIELD, null, false);
    }

    private WoodlandChampionTriggeredAbility(WoodlandChampionTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE_GROUP;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeGroupEvent zEvent = (ZoneChangeGroupEvent)event;
        if (zEvent.getToZone() != Zone.BATTLEFIELD || zEvent.getTokens() == null) {
            return false;
        }
        int tokenCount = zEvent.getTokens().stream().filter(Objects::nonNull).map(PermanentImpl::getControllerId).filter(arg_0 -> ((WoodlandChampionTriggeredAbility)this).isControlledBy(arg_0)).mapToInt(x -> 1).sum();
        if (tokenCount > 0) {
            this.getEffects().clear();
            this.addEffect((Effect)new AddCountersSourceEffect(CounterType.P1P1.createInstance(tokenCount)));
            return true;
        }
        return false;
    }

    public WoodlandChampionTriggeredAbility copy() {
        return new WoodlandChampionTriggeredAbility(this);
    }

    public String getRule() {
        return "Whenever one or more tokens you control enter, put that many +1/+1 counters on {this}.";
    }
}

