/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.LinkedHashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class WordOfUndoingReturnToHandEffect
extends OneShotEffect {
    WordOfUndoingReturnToHandEffect() {
        super(Outcome.ReturnToHand);
        this.staticText = "Return target creature and all white Auras you own attached to it to their owners' hands.";
    }

    private WordOfUndoingReturnToHandEffect(WordOfUndoingReturnToHandEffect effect) {
        super((OneShotEffect)effect);
    }

    public WordOfUndoingReturnToHandEffect copy() {
        return new WordOfUndoingReturnToHandEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        LinkedHashSet<Permanent> attachments = new LinkedHashSet<Permanent>();
        Player player = game.getPlayer(source.getControllerId());
        Permanent target = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (target != null && player != null) {
            for (UUID attachmentId : target.getAttachments()) {
                Permanent attachment = game.getPermanent(attachmentId);
                if (attachment == null || !attachment.isControlledBy(source.getControllerId()) || !attachment.hasSubtype(SubType.AURA, game) || !attachment.getColor(game).isWhite()) continue;
                attachments.add(attachment);
            }
            attachments.add(target);
            player.moveCards(attachments, Zone.HAND, source, game);
            return true;
        }
        return false;
    }
}

