/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.List;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledPermanent;

class WordsOfWindEffect
extends ReplacementEffectImpl {
    WordsOfWindEffect() {
        super(Duration.EndOfTurn, Outcome.ReturnToHand);
        this.staticText = "The next time you would draw a card this turn, each player returns a permanent they control to its owner's hand instead";
    }

    private WordsOfWindEffect(WordsOfWindEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public WordsOfWindEffect copy() {
        return new WordsOfWindEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        game.informPlayers("Each player returns a permanent they control to its owner's hand instead");
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            TargetControlledPermanent target = new TargetControlledPermanent();
            List liste = game.getBattlefield().getActivePermanents((FilterPermanent)new FilterControlledPermanent(), playerId, game);
            if (liste.isEmpty()) continue;
            while (!player.choose(Outcome.ReturnToHand, (Target)target, source, game)) {
                if (player.canRespond()) continue;
                return false;
            }
            Permanent permanent = game.getPermanent(target.getFirstTarget());
            if (permanent == null) continue;
            player.moveCards((Card)permanent, Zone.HAND, source, game);
        }
        this.used = true;
        this.discard();
        return true;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DRAW_CARD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (!this.used) {
            return source.isControlledBy(event.getPlayerId());
        }
        return false;
    }
}

