/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class WordsOfWisdomEffect
extends OneShotEffect {
    WordsOfWisdomEffect() {
        super(Outcome.Detriment);
        this.staticText = ", then each other player draws a card";
    }

    private WordsOfWisdomEffect(WordsOfWisdomEffect effect) {
        super((OneShotEffect)effect);
    }

    public WordsOfWisdomEffect copy() {
        return new WordsOfWisdomEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Player player;
                if (playerId.equals(controller.getId()) || (player = game.getPlayer(playerId)) == null) continue;
                player.drawCards(1, source, game);
            }
        }
        return false;
    }
}

