/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.List;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ChooseExpansionSetEffect;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.SuperType;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class WorldBottlingKitEffect
extends OneShotEffect {
    WorldBottlingKitEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Choose a Magic set. Exile all permanents with that set's expansion symbol except for basic lands";
    }

    private WorldBottlingKitEffect(WorldBottlingKitEffect effect) {
        super((OneShotEffect)effect);
    }

    public WorldBottlingKitEffect copy() {
        return new WorldBottlingKitEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            ChooseExpansionSetEffect effect = new ChooseExpansionSetEffect(Outcome.Exile);
            effect.apply(game, source);
            String setChosen = null;
            if (effect.getValue("setchosen") != null) {
                setChosen = (String)effect.getValue("setchosen");
            } else if (game.getState().getValue(this.getId() + "_set") != null) {
                setChosen = (String)game.getState().getValue(this.getId() + "_set");
            }
            if (setChosen != null) {
                game.informPlayers(controller.getLogName() + " has chosen set " + setChosen);
                FilterPermanent filter = new FilterPermanent();
                filter.add(Predicates.not((Predicate)Predicates.and((Predicate)CardType.LAND.getPredicate(), (Predicate)SuperType.BASIC.getPredicate())));
                List permanents = game.getBattlefield().getActivePermanents(filter, source.getControllerId(), source, game);
                for (Permanent permanent : permanents) {
                    if (!permanent.getExpansionSetCode().equals(setChosen)) continue;
                    controller.moveCardToExileWithInfo((Card)permanent, null, "", source, game, Zone.BATTLEFIELD, true);
                }
            }
            return true;
        }
        return false;
    }
}

