/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CastSourceTriggeredAbility;
import mage.abilities.effects.common.ExileTargetEffect;
import mage.abilities.effects.common.ReturnSourceFromGraveyardToHandEffect;
import mage.abilities.keyword.DevoidAbility;
import mage.abilities.keyword.ReachAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.target.Target;
import mage.target.TargetPermanent;

public final class WorldBreaker
extends CardImpl {
    private static final FilterPermanent filter = new FilterPermanent("artifact, enchantment, or land");

    public WorldBreaker(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, "{6}{G}");
        this.subtype.add((Object)SubType.ELDRAZI);
        this.power = new MageInt(5);
        this.toughness = new MageInt(7);
        this.addAbility((Ability)new DevoidAbility(this.color));
        CastSourceTriggeredAbility ability = new CastSourceTriggeredAbility((Effect)new ExileTargetEffect(), false);
        ability.addTarget((Target)new TargetPermanent(filter));
        this.addAbility((Ability)ability);
        this.addAbility((Ability)ReachAbility.getInstance());
        ability = new SimpleActivatedAbility(Zone.GRAVEYARD, (Effect)new ReturnSourceFromGraveyardToHandEffect(), (Cost)new ManaCostsImpl("{2}{C}"));
        ability.addCost((Cost)new SacrificeTargetCost((FilterPermanent)StaticFilters.FILTER_LAND));
        this.addAbility((Ability)ability);
    }

    private WorldBreaker(WorldBreaker card) {
        super((CardImpl)card);
    }

    public WorldBreaker copy() {
        return new WorldBreaker(this);
    }

    static {
        filter.add(Predicates.or((Predicate[])new Predicate[]{CardType.ARTIFACT.getPredicate(), CardType.ENCHANTMENT.getPredicate(), CardType.LAND.getPredicate()}));
    }
}

