/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.choices.Choice;
import mage.choices.ChoiceImpl;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetSacrifice;

class WorldQuellerEffect
extends OneShotEffect {
    private static final Set<String> choice = new LinkedHashSet<String>();

    WorldQuellerEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may choose a card type. If you do, each player sacrifices a permanent of that type";
    }

    private WorldQuellerEffect(WorldQuellerEffect effect) {
        super((OneShotEffect)effect);
    }

    public WorldQuellerEffect copy() {
        return new WorldQuellerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        ArrayList<Permanent> chosen = new ArrayList<Permanent>();
        Player player = game.getPlayer(source.getControllerId());
        Permanent sourceCreature = game.getPermanent(source.getSourceId());
        if (player != null && sourceCreature != null) {
            ChoiceImpl choiceImpl = new ChoiceImpl(false);
            choiceImpl.setChoices(choice);
            if (!player.choose(Outcome.Neutral, (Choice)choiceImpl, game)) {
                return false;
            }
            CardType type = null;
            String chosenType = choiceImpl.getChoice();
            if (chosenType.equals(CardType.ARTIFACT.toString())) {
                type = CardType.ARTIFACT;
            } else if (chosenType.equals(CardType.LAND.toString())) {
                type = CardType.LAND;
            } else if (chosenType.equals(CardType.CREATURE.toString())) {
                type = CardType.CREATURE;
            } else if (chosenType.equals(CardType.ENCHANTMENT.toString())) {
                type = CardType.ENCHANTMENT;
            } else if (chosenType.equals(CardType.INSTANT.toString())) {
                type = CardType.INSTANT;
            } else if (chosenType.equals(CardType.SORCERY.toString())) {
                type = CardType.SORCERY;
            } else if (chosenType.equals(CardType.PLANESWALKER.toString())) {
                type = CardType.PLANESWALKER;
            } else if (chosenType.equals(CardType.KINDRED.toString())) {
                type = CardType.KINDRED;
            }
            if (type != null) {
                FilterControlledPermanent filter = new FilterControlledPermanent("permanent you control of type " + type.toString());
                filter.add((Predicate)type.getPredicate());
                TargetSacrifice target = new TargetSacrifice((FilterPermanent)filter);
                for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
                    Player player2 = game.getPlayer(playerId);
                    if (player2 == null || !target.canChoose(playerId, source, game)) continue;
                    while (player2.canRespond() && !target.isChosen(game) && target.canChoose(playerId, source, game)) {
                        player2.choose(Outcome.Sacrifice, (Target)target, source, game);
                    }
                    Permanent permanent = game.getPermanent(target.getFirstTarget());
                    if (permanent != null) {
                        chosen.add(permanent);
                    }
                    target.clearChosen();
                }
                for (Permanent permanent : game.getBattlefield().getAllActivePermanents()) {
                    if (!chosen.contains(permanent)) continue;
                    permanent.sacrifice(source, game);
                }
                return true;
            }
        }
        return false;
    }

    static {
        choice.add(CardType.ARTIFACT.toString());
        choice.add(CardType.CREATURE.toString());
        choice.add(CardType.ENCHANTMENT.toString());
        choice.add(CardType.INSTANT.toString());
        choice.add(CardType.LAND.toString());
        choice.add(CardType.PLANESWALKER.toString());
        choice.add(CardType.SORCERY.toString());
        choice.add(CardType.KINDRED.toString());
    }
}

