/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterLandCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.util.CardUtil;

class WorldsoulsRageEffect
extends OneShotEffect {
    WorldsoulsRageEffect() {
        super(Outcome.PutLandInPlay);
        this.staticText = "put up to X land cards from your hand and/or graveyard onto the battlefield tapped.";
    }

    private WorldsoulsRageEffect(WorldsoulsRageEffect effect) {
        super((OneShotEffect)effect);
    }

    public WorldsoulsRageEffect copy() {
        return new WorldsoulsRageEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        FilterLandCard filter = new FilterLandCard();
        CardsImpl landCards = new CardsImpl();
        landCards.addAllCards((Collection)controller.getHand().getCards((FilterCard)filter, source.getControllerId(), source, game));
        landCards.addAllCards((Collection)controller.getGraveyard().getCards((FilterCard)filter, source.getControllerId(), source, game));
        if (landCards.isEmpty()) {
            return false;
        }
        int maxTargets = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
        if (maxTargets == 0) {
            return false;
        }
        TargetCard target = new TargetCard(0, maxTargets, Zone.ALL, (FilterCard)filter);
        target.withNotTarget(true);
        controller.chooseTarget(this.outcome, (Cards)landCards, target, source, game);
        Set chosenCards = target.getTargets().stream().map(arg_0 -> ((Game)game).getCard(arg_0)).filter(Objects::nonNull).collect(Collectors.toSet());
        if (chosenCards.isEmpty()) {
            return false;
        }
        controller.moveCards(chosenCards, Zone.BATTLEFIELD, source, game, true, false, false, null);
        return true;
    }
}

