/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.common.TargetOpponent;
import mage.util.CardUtil;

class WormfangCrabExileEffect
extends OneShotEffect {
    WormfangCrabExileEffect() {
        super(Outcome.Exile);
        this.staticText = "an opponent chooses a permanent you control other than {this} and exiles it";
    }

    private WormfangCrabExileEffect(WormfangCrabExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public WormfangCrabExileEffect copy() {
        return new WormfangCrabExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        TargetOpponent targetOpponent = new TargetOpponent(true);
        controller.choose(this.outcome, (Target)targetOpponent, source, game);
        Player opponent = game.getPlayer(targetOpponent.getFirstTarget());
        if (opponent == null) {
            return false;
        }
        game.informPlayers(controller.getLogName() + " has selected " + opponent.getLogName() + " to choose a permanent to exile" + CardUtil.getSourceLogName((Game)game, (Ability)source));
        FilterPermanent filter = new FilterPermanent();
        filter.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
        filter.add((Predicate)new ControllerIdPredicate(controller.getId()));
        TargetPermanent target = new TargetPermanent(filter);
        target.withNotTarget(true);
        target.withTargetName("a permanent that player controls");
        if (!opponent.choose(this.outcome, (Target)target, source, game)) {
            return false;
        }
        Permanent cardToMove = game.getPermanent(target.getFirstTarget());
        UUID exileId = CardUtil.getExileZoneId((Game)game, (Ability)source);
        return cardToMove != null && opponent.moveCardsToExile((Card)cardToMove, source, game, true, exileId, CardUtil.getSourceName((Game)game, (Ability)source));
    }
}

