/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;

class WorshipReplacementEffect
extends ReplacementEffectImpl {
    WorshipReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "If you control a creature, damage that would reduce your life total to less than 1 reduces it to 1 instead";
    }

    private WorshipReplacementEffect(WorshipReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public WorshipReplacementEffect copy() {
        return new WorshipReplacementEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGE_CAUSES_LIFE_LOSS;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Player controller;
        if (source.isControlledBy(event.getPlayerId()) && (controller = game.getPlayer(source.getControllerId())) != null && controller.getLife() - event.getAmount() < 1 && game.getBattlefield().count((FilterPermanent)new FilterControlledCreaturePermanent(), event.getPlayerId(), source, game) > 0) {
            event.setAmount(controller.getLife() - 1);
        }
        return false;
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        return false;
    }
}

