/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.ConspireAbility;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.common.FilterInstantOrSorcerySpell;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;

class WortGainConspireEffect
extends ContinuousEffectImpl {
    private static final FilterInstantOrSorcerySpell filter = new FilterInstantOrSorcerySpell();
    private final ConspireAbility conspireAbility;

    public WortGainConspireEffect() {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "Each red or green instant or sorcery spell you cast has conspire. <i>(As you cast the spell, you may tap two untapped creatures you control that share a color with it. When you do, copy it and you may choose new targets for the copy.)</i>";
        this.conspireAbility = new ConspireAbility(ConspireAbility.ConspireTargets.MORE);
    }

    private WortGainConspireEffect(WortGainConspireEffect effect) {
        super((ContinuousEffectImpl)effect);
        this.conspireAbility = effect.conspireAbility;
    }

    public WortGainConspireEffect copy() {
        return new WortGainConspireEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (StackObject stackObject : game.getStack()) {
            if (!(stackObject instanceof Spell) || stackObject.isCopy() || !stackObject.isControlledBy(source.getControllerId())) continue;
            Spell spell = (Spell)stackObject;
            if (!filter.match((Object)stackObject, game)) continue;
            game.getState().addOtherAbility(spell.getCard(), (Ability)this.conspireAbility.setAddedById(source.getSourceId()));
        }
        return true;
    }

    static {
        filter.add(Predicates.or((Predicate)new ColorPredicate(ObjectColor.RED), (Predicate)new ColorPredicate(ObjectColor.GREEN)));
    }
}

