/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class WrathfulRedDragonEffect
extends OneShotEffect {
    WrathfulRedDragonEffect() {
        super(Outcome.Benefit);
    }

    private WrathfulRedDragonEffect(WrathfulRedDragonEffect effect) {
        super((OneShotEffect)effect);
    }

    public WrathfulRedDragonEffect copy() {
        return new WrathfulRedDragonEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent dragon = (Permanent)this.getValue("damagedPermanent");
        Integer damage = (Integer)this.getValue("damage");
        if (dragon == null || damage == null) {
            return false;
        }
        UUID targetId = this.getTargetPointer().getFirst(game, source);
        Permanent permanent = game.getPermanent(targetId);
        if (permanent != null) {
            return permanent.damage(damage.intValue(), dragon.getId(), source, game) > 0;
        }
        Player player = game.getPlayer(targetId);
        if (player != null) {
            return player.damage(damage.intValue(), dragon.getId(), source, game) > 0;
        }
        return false;
    }
}

