/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.List;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class WretchedBanquetEffect
extends OneShotEffect {
    WretchedBanquetEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Destroy target creature if it has the least power or is tied for least power among creatures on the battlefield";
    }

    private WretchedBanquetEffect(WretchedBanquetEffect effect) {
        super((OneShotEffect)effect);
    }

    public WretchedBanquetEffect copy() {
        return new WretchedBanquetEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent targetCreature = game.getPermanent(source.getFirstTarget());
        if (targetCreature == null) {
            return false;
        }
        List creatures = game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), source, game);
        int minPower = targetCreature.getPower().getValue() + 1;
        for (Permanent creature : creatures) {
            if (minPower <= creature.getPower().getValue()) continue;
            minPower = creature.getPower().getValue();
        }
        if (targetCreature.getPower().getValue() <= minPower) {
            targetCreature.destroy(source, game, false);
            return true;
        }
        return false;
    }
}

