/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.keyword.ManifestEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class WriteIntoBeingEffect
extends OneShotEffect {
    WriteIntoBeingEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Look at the top two cards of your library. Manifest one of those cards, then put the other on the top or bottom of your library. <i>(To manifest a card, put it onto the battlefield face down as a 2/2 creature. Turn it face up any time for its mana cost if it's a creature card.)</i>";
    }

    private WriteIntoBeingEffect(WriteIntoBeingEffect effect) {
        super((OneShotEffect)effect);
    }

    public WriteIntoBeingEffect copy() {
        return new WriteIntoBeingEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (sourceObject != null && controller != null) {
            Card cardToPutBack;
            CardsImpl cards = new CardsImpl(controller.getLibrary().getTopCards(game, 2));
            controller.lookAtCards(source, null, (Cards)cards, game);
            Card cardToManifest = null;
            if (cards.size() > 1) {
                TargetCard target = new TargetCard(Zone.LIBRARY, new FilterCard("card to manifest"));
                if (controller.chooseTarget(this.outcome, (Cards)cards, target, source, game)) {
                    cardToManifest = cards.get(target.getFirstTarget(), game);
                }
            } else {
                cardToManifest = cards.getRandom(game);
            }
            if (!controller.getLibrary().getFromTop(game).equals(cardToManifest)) {
                cardToPutBack = controller.getLibrary().removeFromTop(game);
                cardToManifest = controller.getLibrary().removeFromTop(game);
                controller.getLibrary().putOnTop(cardToPutBack, game);
                controller.getLibrary().putOnTop(cardToManifest, game);
            }
            new ManifestEffect(1).apply(game, source);
            if (controller.getLibrary().hasCards()) {
                cardToPutBack = controller.getLibrary().getFromTop(game);
                if (controller.chooseUse(Outcome.Detriment, "Put " + cardToPutBack.getName() + " on bottom of library?", source, game)) {
                    controller.putCardsOnBottomOfLibrary(cardToPutBack, game, source);
                } else {
                    controller.putCardsOnTopOfLibrary(cardToPutBack, game, source, true);
                }
            }
            return true;
        }
        return false;
    }
}

