/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.x;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.players.Player;

class XanatharLookAtTopCardOfLibraryEffect
extends ContinuousEffectImpl {
    XanatharLookAtTopCardOfLibraryEffect() {
        super(Duration.EndOfTurn, Layer.PlayerEffects, SubLayer.NA, Outcome.Benefit);
    }

    private XanatharLookAtTopCardOfLibraryEffect(XanatharLookAtTopCardOfLibraryEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public XanatharLookAtTopCardOfLibraryEffect copy() {
        return new XanatharLookAtTopCardOfLibraryEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        if (game.inCheckPlayableState()) {
            return false;
        }
        Player controller = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (controller == null || opponent == null) {
            return false;
        }
        if (!this.canLookAtNextTopLibraryCard(game)) {
            return false;
        }
        Card topCard = opponent.getLibrary().getFromTop(game);
        if (topCard == null) {
            return false;
        }
        controller.lookAtCards("Top card of " + opponent.getName() + "'s library", topCard, game);
        return true;
    }
}

