/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.x;

import mage.MageObject;
import mage.abilities.TriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.common.delayed.WhenTargetDiesDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.constants.Duration;
import mage.constants.SetTargetPointer;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.Token;
import mage.game.permanent.token.XiraBlackInsectToken;

class XiraTheGoldenStingTriggeredAbility
extends WhenTargetDiesDelayedTriggeredAbility {
    XiraTheGoldenStingTriggeredAbility() {
        super((Effect)new DrawCardSourceControllerEffect(1), Duration.Custom, SetTargetPointer.NONE);
        this.addEffect((Effect)new CreateTokenEffect((Token)new XiraBlackInsectToken()).concatBy("and"));
        this.setTriggerPhrase("When that creature dies, if it has an egg counter on it, ");
        this.setLeavesTheBattlefieldTrigger(true);
    }

    private XiraTheGoldenStingTriggeredAbility(XiraTheGoldenStingTriggeredAbility ability) {
        super((WhenTargetDiesDelayedTriggeredAbility)ability);
    }

    public XiraTheGoldenStingTriggeredAbility copy() {
        return new XiraTheGoldenStingTriggeredAbility(this);
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent = ((ZoneChangeEvent)event).getTarget();
        return permanent != null && permanent.getCounters(game).containsKey(CounterType.EGG) && super.checkTrigger(event, game);
    }

    public boolean isInactive(Game game) {
        int zccdiff = game.getState().getZoneChangeCounter(this.mor.getSourceId()) - this.mor.getZoneChangeCounter();
        return zccdiff > 1 || zccdiff > 0 && game.getState().getZone(this.mor.getSourceId()) != Zone.GRAVEYARD;
    }

    public boolean isInUseableZone(Game game, MageObject sourceObject, GameEvent event) {
        return TriggeredAbilityImpl.isInUseableZoneDiesTrigger((TriggeredAbility)this, (MageObject)sourceObject, (GameEvent)event, (Game)game);
    }
}

