/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.y;

import java.util.Collection;
import java.util.HashMap;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInHand;

class YaroksFenlurkerEffect
extends OneShotEffect {
    YaroksFenlurkerEffect() {
        super(Outcome.Benefit);
        this.staticText = "each opponent exiles a card from their hand";
    }

    private YaroksFenlurkerEffect(YaroksFenlurkerEffect effect) {
        super((OneShotEffect)effect);
    }

    public YaroksFenlurkerEffect copy() {
        return new YaroksFenlurkerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Boolean applied = false;
        HashMap<UUID, CardsImpl> cardsToExile = new HashMap<UUID, CardsImpl>();
        for (UUID opponentId : game.getOpponents(source.getControllerId())) {
            Player opponent = game.getPlayer(opponentId);
            if (opponent == null || opponent.getHand().isEmpty()) continue;
            int numberOfCardsToExile = Math.min(1, opponent.getHand().size());
            TargetCardInHand target = new TargetCardInHand(numberOfCardsToExile, StaticFilters.FILTER_CARD);
            target.setRequired(true);
            if (!opponent.chooseTarget(Outcome.Exile, (Target)target, source, game)) continue;
            CardsImpl cards = new CardsImpl((Collection)target.getTargets());
            cardsToExile.put(opponentId, cards);
        }
        CardsImpl cardsOpponentsChoseToExile = new CardsImpl();
        for (UUID opponentId : game.getOpponents(source.getControllerId())) {
            Player opponent = game.getPlayer(opponentId);
            if (opponent == null || !cardsToExile.containsKey(opponentId)) continue;
            cardsOpponentsChoseToExile.addAll((Collection)cardsToExile.get(opponentId));
            opponent.moveCards((Cards)cardsOpponentsChoseToExile, Zone.EXILED, source, game);
            applied = true;
        }
        return applied;
    }
}

