/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.y;

import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BecomesFaceDownCreatureEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class YarusRoarOfTheOldGodsEffect
extends OneShotEffect {
    YarusRoarOfTheOldGodsEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "return it to the battlefield face down under its owner's control if it's a permanent card, then turn it face up";
    }

    private YarusRoarOfTheOldGodsEffect(YarusRoarOfTheOldGodsEffect effect) {
        super((OneShotEffect)effect);
    }

    public YarusRoarOfTheOldGodsEffect copy() {
        return new YarusRoarOfTheOldGodsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (controller == null || card == null || !card.isPermanent(game)) {
            return false;
        }
        Ability newSource = source.copy();
        newSource.setWorksFaceDown(true);
        MageObjectReference mor = new MageObjectReference(card.getId(), card.getZoneChangeCounter(game) + 1, game);
        game.addEffect((ContinuousEffect)new BecomesFaceDownCreatureEffect(null, mor, Duration.Custom, BecomesFaceDownCreatureEffect.FaceDownType.MANUAL), newSource);
        controller.moveCards(card, Zone.BATTLEFIELD, source, game, false, true, true, null);
        Permanent permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game);
        if (permanent != null) {
            permanent.turnFaceUp(source, game, source.getControllerId());
        }
        return true;
    }
}

