/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.y;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.SearchEffect;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class YavimayaDryadEffect
extends SearchEffect {
    YavimayaDryadEffect(TargetCardInLibrary target) {
        super(target, Outcome.PutLandInPlay);
        this.staticText = "you may search your library for a Forest card, put it onto the battlefield tapped under target player's control, then shuffle";
    }

    private YavimayaDryadEffect(YavimayaDryadEffect effect) {
        super((SearchEffect)effect);
    }

    public YavimayaDryadEffect copy() {
        return new YavimayaDryadEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player targetPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (controller == null || targetPlayer == null) {
            return false;
        }
        if (controller.searchLibrary(this.target, source, game)) {
            if (!this.target.getTargets().isEmpty()) {
                targetPlayer.moveCards(new CardsImpl((Collection)this.target.getTargets()).getCards(game), Zone.BATTLEFIELD, source, game, true, false, false, null);
            }
            controller.shuffleLibrary(source, game);
            return true;
        }
        return false;
    }
}

